// ------------------------------------
//    OnBoardC file listbox Library
//            Version 2.01
//    by: Harry Konstas May.19/2000
// ------------------------------------

#include "OBL.h" 

CharPtr ItemsBuffer;

UInt MakeFileList(UInt ListID, ULong creator, ULong type, CharPtr mask)
{

  UInt card;
  LocalID id;
  VoidHand h;
  ListPtr l;
  UInt i, len, lbnum=0, offset=0;
  char name[80];
  Boolean ns = true;
  DmSearchStateType s;

  ItemsBuffer = MemPtrNew(3000);
  
  while(DmGetNextDatabaseByTypeCreator(ns,&s,type,creator,false,&card,&id)==0)
  {
    ns = false;

    DmDatabaseInfo(card,id,&name,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
    len = StrLen(name);
    if(StrLen(mask)==0||StrStr(name,mask)) {
      for(i=0;i<len;i++) 
        ItemsBuffer[offset+i] = name[i];

      offset+=len; if(offset>2900) break;
      ItemsBuffer[offset++]=0;lbnum++;
    }
  }

  if(lbnum>0) {
    l=GetObjectPtr(ListID);
    h=SysFormPointerArrayToStrings(ItemsBuffer,lbnum);
    LstSetListChoices(l,MemHandleLock(h),lbnum);
    LstSetSelection(l,0);
    LstMakeItemVisible(l,0);
    MemHandleUnlock(h);
  }

  return lbnum;
}

UInt MakeStrList(UInt ListID, UInt strID)
{

  UInt card;
  LocalID id;
  VoidHand h;
  ListPtr l;
  UInt i,x=0, len, lbnum=0, offset=0;
  char name[80];
  Boolean ns = true;
  DmSearchStateType s;

  ItemsBuffer = MemPtrNew(3000);
  
  while(1) {
    GetSysString(strID,x++,name);
    len = StrLen(name);
    if(len<3) break;

    for(i=0;i<len;i++) 
      ItemsBuffer[offset+i] = name[i];

    offset+=len; if(offset>2990) break;
    ItemsBuffer[offset++]=0;lbnum++;
  }
  ItemsBuffer[offset]=0;

  if(lbnum>0) {
    l=GetObjectPtr(ListID);
    h=SysFormPointerArrayToStrings(ItemsBuffer,lbnum);
    LstSetListChoices(l,MemHandleLock(h),lbnum);
    LstSetSelection(l,0);
    LstMakeItemVisible(l,0);
    MemHandleUnlock(h);
  }

  return lbnum;
}

char *GetListItem(UInt ListID)
{

  int i;
  ListPtr l;

  l=GetObjectPtr(ListID);
  i=LstGetSelection(l);
  return LstGetSelectionText(l,i); 
        
}

void DiscardFileList(void)
{
  MemPtrFree(ItemsBuffer);
}
